	org 43789

;===============================================================================	
	; USR 43789 - Variable z1 (redefined if original game
	; chosen) - prints original title
	; black out the attributes of the top 9 lines
	xor a	; LD A,0
	call fblackout
	; MAIN SCREEN TURN ON
	ld a,2
	call 5633
	; set ATTR_T to 0 so everything PRINTS black on black
	ld hl,23695
	ld (hl),0
	; PRINT AT 0,0;
	ld a,22
	rst 16
	xor a
	rst 16
	xor a
	rst 16
	; Print the 288 characters
	ld hl,fcharsdata
	ld bc,288
floop1:	ld a,(hl)
	rst 16
	inc hl
	dec bc
	ld a,b
	or c
	jr nz,floop1
	; now colour it in - black on yellow
	ld a,48	; yellow paper, black ink
	call fblackout
	; invert the colours of the "O"
	ld hl,22711
	ld (hl),6
	; and we're done
	ret
fblackout:
	ld hl,22528
	ld (hl),a
	ld de,22529
	ld bc,287
	ldir
	ret
fcharsdata:
	defb 144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144
	defb 144,144,144,144,144,144,144,143,144,144,144,144,144,144,144,144
	defb 32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32
	defb 32,32,32,32,32,32,133,143,138,32,32,32,32,32,32,32
	defb 129,130,143,32,133,138,32,32,32,32,32,32,32,32,32,129
	defb 130,32,32,32,32,32,143,32,143,32,32,132,139,32,32,131
	defb 135,138,143,32,133,138,32,135,138,133,138,142,142,143,136,135
	defb 138,143,137,135,136,133,138,32,133,138,129,143,131,131,129,143
	defb 133,138,143,132,133,138,136,143,32,141,138,143,129,133,138,133
	defb 138,143,32,141,130,143,132,140,136,143,32,143,32,132,32,143
	defb 131,130,131,131,129,131,130,129,131,129,130,131,32,131,32,131
	defb 130,131,129,131,135,142,130,79,129,141,138,129,131,130,129,131
	defb 144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144
	defb 144,144,144,144,143,32,131,131,131,32,143,144,144,144,144,144
	defb 32,32,32,66,89,32,74,46,82,46,32,87,65,84,69,82
	defb 77,65,78,133,143,143,143,143,143,143,143,138,50,48,50,48
	defb 144,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144
	defb 144,144,144,143,32,32,32,32,32,32,32,143,144,144,144,144


;===============================================================================	
	; USR 44136 - Variable ck - Clears all key highlights

	ld hl,22688
	ld de,32
	ld b,16
eloop1:	ld (hl),56
	add hl,de
	djnz eloop1
	ret


; ==============================================================
	; USR 44150 - Variable pk - hard-inverts the "inner border" where KEY, TRIES
	; and all messages are printed

	; need to hard-invert (0,0) to (0,10)
	; all (x,0) and (x,31) for x=1 to 20
	; entire bottom row
	ld d,0	; D will be 0 for this entire routine
	; hard-invert the borders to PAPER 7: INK 0: BRIGHT 1
	ld hl,16384	; start at top line of (0,0) 
	ld c,11		; number of character squares to invert
	call dinverter
	ld hl,16405	; start at top line of (0,21)
	ld c,11
	call dinverter
	ld hl,16416	; start at top line of (0,0)
	ld b,7
	call dmulti
	ld hl,18432	; start at top line of (8,0)
	ld b,8
	call dmulti	
	ld hl,20480	; start at top line of (16,0)
	ld b,5
	call dmulti
	ld hl,20640	; start at top line of (21,0)
	ld c,32
	call dinverter
	ret
dinverter:
	push bc	; store the loop variable from outside the
		; subroutine, if there is one
	push hl	; store this as well, just in case...
		; DE = amount to add to HL after the loop to
		; get HL in place for the next line = 256-A
		; i.e. D=0 and E="NEG A"
	ld a,c
	neg	; A is now the required value of E
	ld e,a	; DE is now 256-A
	; invert the lines
	ld b,8
dloop1:	push bc		; store outer loop variable
	ld b,c		; number of times to loop - A is now free to use again
dloop2:	ld a,(hl)	; get the DF address into A
	cpl		; flip all the bits
	ld (hl),a	; put it back into the DF
	inc hl		; move right
	djnz dloop2
	pop bc		; get outer loop variable back
	add hl,de	; HL is now at the start of the next line
	djnz dloop1
	pop hl		; get external HL back
	pop bc		; get external loop variable back
	ret
dmulti:	ld c,1
	call dinverter
	ld e,31		; DE=31
	add hl,de	; HL is in place for (*,31)
	ld c,1
	call dinverter
	inc hl
	djnz dmulti
	ret



;===============================================================================	
	; USR 44241 - Variable kt - Prints KEY and TRIES captions, keys in small
	; characters, and TRIES counter in three colours
	
	ld a,2
	call 5633	; main screen turn on
	; B is number of times to loop
	; C is the column to be printed in
	ld hl,ctextdata1
	ld bc,768	; LD B,3: LD C,0
	call cprintsub1
	ld hl,ctextdata2
	ld bc,1311	; LD B,5: LD C,31
	call cprintsub1
	; print some small characters for the keys
	ld de,cdfdata1	; start of data for small characters
	; rows 5-7 (top half)
	ld hl,17056	; (5,0) row 3
	ld b,3
cloop1:	call cprintsub2
	djnz cloop1
	; rows 8-15
	ld hl,18944	; (8,0) row 3
	ld b,8
cloop2:	call cprintsub2
	djnz cloop2
	; rows 16-20
	ld hl,20992	; (16,0) row 3
	ld b,5
cloop3:	call cprintsub2
	djnz cloop3
	; colour in the attributes for TRIES counter
	ld hl,22751	; ATTR (6,31)
	ld de,32
	ld bc,1593	; LD B,6 (loop variable): LD C,57 (ATTR required)
	call cattrfill
	ld bc,1339	; LD B,5: LD C,59
	call cattrfill
	ld bc,1082	; LD B,4: LD C,58
	call cattrfill
	; draw the lines
	ld b,40		; B holds the number of times to loop and is not involved
			;   in the calculation routine; POKE org+81 with the
			;   intended value to change it
	ld a,24		; A = y-coordinate + 16 which this routine needs
			;   the original routine will adjust it but in this case
			;   it's better to start with the adjusted value
			;   A = 24 is a starting y-coordinate of 8.
cloop4:	call cdfcalc	; convert A to the display file address
	ld (hl),126	; draw a line
	inc a		; move to the next y-coord+16
	call cdfcalc	; convert new coordinate to DF address
	ld (hl),126	; draw another line
	inc a		; move A by two this time
	inc a
	; insert sound here
	push af
	push bc
	ld h,b		; provides a bit of variance in the HL value used
			;   according to the loop: DE needs to be as short as
			;   possible, and a value of 0 will work but a static
			;   value means the overall delay gets shorter as
			;   the value of HL decreases
	ld de,2		; this is about the best I'll get...
	call 949
	ld b,255
cdelay:	djnz cdelay
	pop bc
	pop af
	djnz cloop4
	; ALL DONE!
	ret
; Subroutines for "kt":
cprintsub1:
	ld a,22
	rst 16
	ld a,b	; row is the same as the loop variable
	rst 16	; (as long as we read the text backwards)
	ld a,c	; column was defined in LD BC
	rst 16
	ld a,(hl)
	rst 16
	inc hl
	djnz cprintsub1
	ret
cprintsub2:
	push bc	; need to store initial loop variable
	ld b,5
cloop5:	ld a,(de)
	ld (hl),a	; contents at DE are now on screen
	inc de
	inc h		; move one DF row down
	djnz cloop5	; HL will need adjusting at the end of this loop
	push de
	ld de,1248
	and a
	sbc hl,de	; HL is correctly adjusted for
	pop de		; row 3 of next square down
	pop bc
	ret
cattrfill:
	ld (hl),c
	add hl,de
	djnz cattrfill
	ret
cdfcalc:
; The original calculation to convert PRINT AT positions to the DF address
; can be found in Dilwyn Jones' "Beyond Simple BASIC", page 156-157
; There is also an explanation of the display file:
; Bits of high byte: 
; +----7----+----6----+----5----+----4----+----3----+----2----+----1----+----0----+
; | Fixed value to point to the |00 if in top third |  Which line of dots in the  |
; | start of the display file   |of the screen      |  character block - 0 for    |
; | bits are:                   |01 if in middle    |  top row, 7 for bottom row  |
; |    0         1         0    |third; 10 in bottom|                             |
; +---------+---------+---------+---------+---------+---------+---------+---------+
; Bits of low byte:
; +----7----+----6----+----5----+----4----+----3----+----2----+----1----+----0----+
; | In the active third of the  |                                                 |
; | screen, which character     |            PRINT AT column, 0-31                |
; | rows 0-7 (PRINT AT coords   |                 = INT (x/8)                     |
; | may be useful here)         |                                                 |
; +---------+---------+---------+---------+---------+---------+---------+---------+
; FOR THIS ROUTINE: x-coord is fixed at 31
; To translate y-coord to the correct bits:
; LD HL,16415 (sets bits 7,6,5 of H and bits 4,3,2,1,0 correctly)
; Define A=y+16 (because y can technically range from -16 to 175)
; A ranges from 0-191.
	ld hl,16415	; bits 7,6,5 of H and bits 4,3,2,1,0 of L are set correctly
	push af		; need to save the original value of A
; Deal with bits 4&3 of H:
; IF A>=128 (y>=112), H bits 4&3 = 00		(Top two bits of A = 10)
; IF A>=64,<128 (y>=48,<112), H bits = 01	(Top two bits of A = 01)
; IF A<64 (y<48 or y>=239), H bits = 10		(Top two bits of A = 00)
; i.e.
; If bit 7 of A = 1, H bits 4&3 are already 00, nothing more to test
; If bit 6 of A = 1, set bit 3 of H
; If bit 6 of A = 0, set bit 4 of H
	bit 7,a		; if bit 7 is set, Z flag RESET
	jr nz,cnextphase	; jump to next section if Z is RESET
	bit 6,a		; if bit 6 is set, Z flag RESET
	jr nz,cother	; jump to second test if Z is RESET
	set 4,h		; if bit 6 is NOT set, set bit 4 of H
cother:	jr z,cnextphase	; so now if we've just set bit 4 (i.e. Z reset) we do NOT want to set bit 3
	set 3,h		; now bits 4 and 3 of H are set correctly
; Bits 2,1,0 of H:
; A AND 7 is the opposite way round to what we want for bits 2,1,0 of H.
; But: take CPL of A to invert all the bits and then AND 7 with that, we have the right bits.
; Add this to H.
cnextphase:
	push af			; need to save a copy of the value we're working on.
	cpl				; invert all the bits of A so that the values increase as Y decreases
	and 7			; the bottom three bits are what we want
	or h			; H has only the top five bits set; merge it into A
	ld h,a			; and put that back into H which is now done with.
; Bits 7,6,5 of L:
; Recall the A from before.
; A AND 63 cuts off the top two bits so that there's the repeating pattern over the
; three parts of the screen.
; CPL this - values are between 192 and 155. 
; AND 56 this value, to cut off the two highest bits and round to the nearest multiple of 8
; - the value we want is obtained by dividing all these by 8.
; ACTUALLY: no need for the AND 63 step because the top two bits will be lost anyway in AND 56...!
; The three bits we want are in 5,4,3 but they need to be put into 7,6,5 of L so shift left twice.
; The AND 56 has cleared the carry and all the other bits are empty so we can use RL.
	pop af			; get our unmolested A back
	cpl			; invert the bits so that the values increase as before
	and 56			; the three bits we want are 5,4,3
	rla			; move the bits to 7,6,5
	rla
	or l			; merge with L which has bits 4,3,2,1,0 already set
	ld l,a			; and put that back into L.
; HL is now set correctly with the DF address for the y-coordinate we want.	
	pop af			; get our original A back
	ret	
; Data tables for routine "kt"
ctextdata1:	defm "YEK"
ctextdata2:	defm "SEIRT"
cdfdata1:
	defb 60,32,56,32,32	; F
	defb 60,32,56,32,60	; E
	defb 56,36,36,36,56	; D
	defb 28,32,32,32,28	; C
	defb 56,36,56,36,56	; B
	defb 24,36,60,36,36	; A
	defb 24,36,28,4,24	; 9
	defb 24,36,24,36,24	; 8
	defb 60,4,8,16,32	; 7
	defb 24,32,56,36,24	; 6
	defb 60,32,56,4,56	; 5
	defb 8,24,40,60,8	; 4
	defb 56,4,24,4,56	; 3
	defb 56,4,24,32,60	; 2
	defb 8,24,8,8,28	; 1
	defb 24,36,36,36,24	; 0



;===============================================================================	
	; USR 44515 - Variable nf - Converts NPC face graphics (LM on top, NO on
	; bottom) to attributes at the bottom left corner of the screen.
	; NPC face is 14 wide with a blank strip at the left side so print it one
	; attribute before where it's supposed to be, and the bit left hanging on
	; the right side of the screen will be invisible anyway.

	ld hl,22798	; ATTR of (8,14) - top right corner
	ld ix,65456	; USR "l"
	call bprintattrs
	ld hl,23054	; ATTR of (16,14)
	ld ix,65472	; USR "n"
	call bprintattrs
	ret
bprintattrs:
	ld b,8
bloop1:	push bc
	ld d,(ix+0)
	ld e,(ix+8)	; DE contains the top rows of UDGs "LM"
	ld b,16
bloop2:	; Shift D right, highest bit 0, lowest bit into carry
	; Rotate E right - carry into highest bit, lowest bit into carry
	srl d
	rr e
	; if carry is set, change the attribute in DE to black on white (56)
	; it is currently set to white on black (7)
	; if carry is not set, jump over this step
	jr nc,bjump3
	ld (hl),56
bjump3:	dec hl
	djnz bloop2
	inc ix	; move onto next row of the graphics
	ld bc,48	; use BC while we can
	add hl,bc	; move HL to next attribute position
	pop bc
	djnz bloop1
	ret



;===============================================================================	
	; USR 44568 - Variable fb - Fade screen to black, cycle through colours

	ld b,8		; cycle through 8 colours (7-0)
	; colour will be (B-1)
aloop1:	push bc		; store loop variable
	ld hl,22528	; start at top of attributes
 	ld (hl),b	; load attribute at HL with FLASH 0: BRIGHT 0: PAPER 0: INK B
	dec (hl)	; correct attribute - we want (B-1)
	ld de,22529	; select next attribute position
	ld bc,767	; set BC to fill all but one attribute positions
	ldir		; fill attribute positions
	dec a		; reduce A by 1

; need to insert a delay loop
	ld bc,15000
adelay:	dec bc
	ld a,b
	or c
	jr nz,adelay

	pop bc		; get original B back
	djnz aloop1
	ret

